﻿#include "precompiled.h"
#include "common.h"
#include "GeometryShader.h"

using namespace DirectX;

namespace RTCam {

GeometryShader::GeometryShader(void) :
	m_geometryShader(nullptr)
{
}


GeometryShader::~GeometryShader(void)
{
}

ComPtr<ID3DBlob> GeometryShader::Load(_In_z_ const char* filename, _In_ ID3D11Device1* d3dDevice)
{
	ComPtr<ID3DBlob> shaderBlob = LoadShader(filename, "main", "gs_5_0");
	ThrowIfFailed(
		d3dDevice->CreateGeometryShader(
		shaderBlob->GetBufferPointer(),
		shaderBlob->GetBufferSize(),
		nullptr,
		&m_geometryShader
		)
		);

	SetDebugObjectName(m_geometryShader.Get(), filename);

	return shaderBlob;
}

} // end namespace